# Git Bash and stash in Windows
https://confluence.detss.corpintra.net/display/SYSTEMS/GIT+Server+Authentication

## Clone with SSH
* Environment variable `GIT_SSH` temporary
    ```` 
    export GIT_SSH=/c/ProgramData/chocolatey/bin/plink.exe
    ````
* Configure environment variable permanently
    ````
    C:\ProgramData\chocolatey\bin\plink.exe 
    ````
* Start putty once and call known address to add host key
  * Server: `stash.detss.corpintra.net`
  * Port: 7999

* As long pageant is not started this will still give an error message
`FATAL ERROR: No supported authentication methods available (server sent: publickey)`

## Start pageant at boot
```
C:\ProgramData\chocolatey\bin\PAGEANT.EXE
C:\ProgramData\Microsoft\Windows\Start Menu\Programs\StartUp
C:\Users\<USER>\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup
```
* Load keys automatically on startup
  * Target: "C:\Program Files\PuTTY\Pageant.exe" key1.ppk key2.ppk key3.ppk
  * Start in: "C:\Documents and Settings\<USER>\.ssh\"

## Clone with HTTP

* Copy trusted certificates
```` 
cp files\ca-certificates-plus-stash.crt C:\documents\certificates\ca-certificates-plus-stash.pem
````
* Use custom trusted certificates chain 
```
git config --global http.sslCAInfo C:\documents\certificates\ca-certificates-plus-stash.pem
git config http.proxy http://127.0.0.1:3128
git config https.proxy http://127.0.0.1:3128
```
