#!/usr/bin/env python
import re

from ansible.module_utils.urls import open_url
from ansible.plugins.lookup import LookupBase
from bs4 import BeautifulSoup
from pprint import pprint
import datetime

URL_ANACONDA = "https://repo.anaconda.com/archive/"
URL_MINICONDA = "https://repo.continuum.io/miniconda/"
PATTERN_PYTHON = re.compile(
    r"Miniconda(?P<python>\d+)-(?P<version>[0-9]+.[0-9]+.[0-9]+|latest)-(?P<os>\w+)-(?P<arch>\w+).\w+")
RELEASE_MAX_AGE_DAYS = 180


def main():
    request = open_url(url=URL_MINICONDA, method="GET")
    response = request.read()

    data = []
    soup = BeautifulSoup(response, "html.parser")
    table = soup.find('table')
    rows = table.find_all('tr')
    header = [element.text for element in rows[0].find_all('th')]
    now = datetime.datetime.now()

    for row in rows[1:]:
        cols = row.find_all('td')
        cols = [ele.text.strip() for ele in cols]
        release = {key: value for key, value in zip(header, cols)}
        result = PATTERN_PYTHON.match(release["Filename"])
        if result:
            info = {
                "python": result.group("python"),
                "version": result.group("version"),
                "os": result.group("os"),
                "arch": result.group("arch")
            }
            release.update(info)
            timestamp = datetime.datetime.strptime(release["Last Modified"], "%Y-%m-%d %H:%M:%S")
            if (now - timestamp).days > RELEASE_MAX_AGE_DAYS:
                continue
            if release["os"] == "Linux" and release['arch'] == 'x86_64' and release["python"] == "3":
                data.append(release)

    latest_item = [item for item in data if item["version"] == "latest"]
    latest_version = [item for item in data if item["MD5"] == latest_item[0]["MD5"]]
    pprint(data)
    print(latest_version[0]["version"])


if __name__ == '__main__':
    main()
