## Manage Virtualbox configuration
* [Documentation CLI VBoxManage](https://www.virtualbox.org/manual/ch08.html)

### Useful commands
* List running vms
`VBoxManage list vms`
* Long listing (including configuration)
`VBoxManage list vms -l`
* Show vm config
`VBoxManage showvminfo devbox`
* List known hdds (including storage location)
`VBoxManage list hdds`

## Configure guest to use hosts nameservers
```
VBoxManage modifyvm "<VM name>" --natdnshostresolver1 on
```

## Issues
Copy&Paste no longer working after update. Reinstall guest additions in guest system.
Check system service: "systemctl status vboxadd"
If necessary attach guest additions in virtualbox and reinstall them from mounted path in e.g. "/opt/VBoxGuestAdditions-6.0.10/init/vboxadd"

