# Documentation Reference
This repository contains information on setting up your developer machine quickly.
On Windows it uses the package manager chocolatey.
On Linux there is a configuration with vagrant and ansible booting a basic setup on basis of Debian.

There is more documentation on customization (other base images and more), see folder `doc`.

# Quickstart
Just get me started ...
* Ensure execution policy is at least `RemoteSigned`
```
Get-ExecutionPolicy
```
* Install chocolatey behind proxy
```
[System.Net.WebRequest]::DefaultWebProxy.Credentials = [System.Net.CredentialCache]::DefaultCredentials; iex ((New-Object System.Net.WebClient).DownloadString('https://chocolatey.org/install.ps1'))
```
* Enable chocolatey's feature auto confirmation
```
choco feature enable -n allowGlobalConfirmation
```
* Install git + firefox
```
choco install firefox git
```
* Get Daimler certificate authority (CA) from stash.detss.corpintra.net (export certificate chain in pem format)
``` 
files\ca-certificates-plus-stash.crt
```
* Configure git to use the Daimler CA
```
git config --global http.sslCAInfo C:\documents\stash.pem
```
* Install vagrant, virtualbox and optionally some desktop packages
```
choco install windows\packages\virtualization.config
choco install windows\packages\desktop.config
```
* Configure squid proxy on windows host and change username in configuration file
Copy files\squid.conf C:\Squid\etc\squid\squid.conf
* Restart Squid proxy using windows system service
* Configure vagrant to use the proxy
```
source proxy.sh
vagrant plugin install vagrant-proxyconf
vagrant plugin install vagrant-disksize
```

* Start VM
```
vagrant up
```
